/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_issend.c,v 1.10 2005/06/29 00:23:16 eugene Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <unistd.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"
#include "tcp.h"
#include "packet.h"

/*
mx_return_t
mx_isend(mx_endpoint_t endpoint,
	     mx_segment_t *segments_list,
	     uint32_t segments_count,
	     mx_endpoint_addr_t dest_endpoint,
	     uint64_t match_data,
	     void *callback_arg,
	     mx_request_t *handle)
*/

mx_return_t 
mx_issend(mx_endpoint_t endpoint, 
	  mx_segment_t *segments_list, 
	  uint32_t segments_count, 
	  mx_endpoint_addr_t destination,
	  uint64_t match_info,
	  void *context, 
	  mx_request_t *request)
{
    return mx_isend_with_type(endpoint, segments_list, segments_count,
                              destination, match_info,
                              context, request, MX_SR_TYPE_ISSEND,
                              0, 0, 0);
}
